/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers.armor;

import com.james.tinkerscalibration.Utils;
import com.james.tinkerscalibration.effect.BloodThirstyArmorEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.modules.technical.ArmorLevelModule;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;

public class ArmorBloodThirstyModifier
extends Modifier {
    private static final TinkerDataCapability.TinkerDataKey<Integer> BLOOD = TConstruct.createKey((String)"bloodthirsty_armor");

    public ArmorBloodThirstyModifier() {
        MinecraftForge.EVENT_BUS.addListener(ArmorBloodThirstyModifier::onHurt);
    }

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addModule((HookProvider)new ArmorLevelModule(BLOOD, false, null));
    }

    private static void onHurt(LivingHurtEvent event) {
        LivingEntity living = event.getEntity();
        living.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(holder -> {
            int levels = (Integer)holder.get(BLOOD, (Object)0);
            if (levels > 0 && event.getAmount() > 0.0f) {
                int effectLevel = Math.min(7, ((BloodThirstyArmorEffect)((Object)((Object)Utils.bloodArmorEffect.get()))).getLevel(living) + 1);
                ((BloodThirstyArmorEffect)((Object)((Object)Utils.bloodArmorEffect.get()))).apply(living, 100, effectLevel, true);
            }
        });
    }
}

